### 62.2. 启动前自定义Environment或ApplicationContext

每个SpringApplication都有ApplicationListeners和ApplicationContextInitializers，用于自定义上下文（context）或环境(environment)。Spring Boot从`META-INF/spring.factories`下加载很多这样的内部使用的自定义。有很多方法可以注册其他的自定义：

* 以编程方式为每个应用注册自定义，通过在SpringApplication运行前调用它的`addListeners`和`addInitializers`方法来实现。
* 以声明方式为每个应用注册自定义，通过设置`context.initializer.classes`或`context.listener.classes`来实现。
* 以声明方式为所有应用注册自定义，通过添加一个`META-INF/spring.factories`并打包成一个jar文件（该应用将它作为一个库）来实现。

SpringApplication会给监听器（即使是在上下文被创建之前就存在的）发送一些特定的ApplicationEvents，然后也会注册监听ApplicationContext发布的事件的监听器。查看Spring Boot特性章节中的[Section 22.4, “Application events and listeners” ](../IV. Spring Boot features/22.4. Application events and listeners.md)可以获取一个完整列表。
